/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.pa.PADataFieldsNode;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardControl;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.apps.taskman.toolkit.dialog.VWTaskWizardDialog;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PADataFieldExportWizard
extends VWTaskWizardDialog {
    PADataFieldsNode m_node = null;
    SelectExportFile m_filePanel = null;

    public PADataFieldExportWizard(PADataFieldsNode node) {
        super((Frame)VWTaskCore.getInstance().getMainFrame(), VWResource.ExportDataFields, VWStringUtils.stringToDimension(VWResource.ExportDataFieldsDialogDim));
        this.m_node = node;
        this.setConfirmOnCancel(false);
        this.setButtonVisible(0, false);
        this.setButtonVisible(1, false);
        this.setButtonText(2, VWResource.Export);
        this.m_filePanel = new SelectExportFile();
        this.addWizardPanel(this.m_filePanel);
    }

    public void finish() throws Exception {
        this.m_node.getPANode().exportDataFields(this.m_filePanel.getExportFile());
    }

    public class SelectExportFile
    extends JPanel
    implements IVWTaskWizardPanel,
    IVWTaskWizardControl,
    KeyListener,
    ActionListener {
        JButton browseButton = null;
        JTextField exportFileTxt = null;

        public SelectExportFile() {
            this.initLayout();
        }

        public String getExportFile() {
            return this.exportFileTxt.getText().trim();
        }

        public void performValidation() throws Exception {
        }

        public String getInstructions() {
            return VWResource.ExportDataFieldsInstructions;
        }

        public String getHelpPath() {
            return VWHelp.Help_Process_TaskManager + "pa_data_fields_export.htm";
        }

        public void refresh() {
        }

        public boolean allowButtonToBeEnabled(int button) {
            if (button == 2) {
                return !this.exportFileTxt.getText().trim().equals("");
            }
            return false;
        }

        public void keyReleased(KeyEvent evt) {
            PADataFieldExportWizard.this.updateButtonState();
        }

        public void keyPressed(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.browseButton) {
                FileDialog exportFileDialog = new FileDialog(VWTaskCore.getInstance().getMainFrame());
                exportFileDialog.setMode(1);
                exportFileDialog.setTitle(VWResource.Export);
                exportFileDialog.setFile(VWResource.ExportFileSaveFilterName);
                exportFileDialog.show();
                String filePath = exportFileDialog.getDirectory();
                String fileName = exportFileDialog.getFile();
                if (filePath != null && fileName != null) {
                    this.exportFileTxt.setText(filePath + fileName);
                    PADataFieldExportWizard.this.updateButtonState();
                }
            }
        }

        private void initLayout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 2;
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(10, 10, 0, 0);
            this.add((Component)new JLabel(VWResource.ExportFile + ":"), c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(10, 10, 0, 0);
            this.exportFileTxt = new JTextField();
            this.exportFileTxt.addKeyListener(this);
            this.add((Component)this.exportFileTxt, c);
            c.gridx = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(10, 10, 0, 10);
            this.browseButton = new JButton(VWResource.Browse);
            this.browseButton.addActionListener(this);
            this.add((Component)this.browseButton, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 3;
            c.insets = new Insets(0, 0, 0, 0);
            this.add(Box.createHorizontalStrut(1), c);
        }

        public boolean skipThisPanel() {
            return false;
        }
    }
}

